#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtSerialPort>
#include <QThread>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_pushButtonStart_clicked();

    void on_pushButtonStop_clicked();

    void on_timer();

    void readData();

    void handleError(QSerialPort::SerialPortError error);

    void cellSelected(int nRow, int nCol);

    void cellChanged(int nRow, int nCol);

private:
    Ui::MainWindow *ui;

    QTimer *timer;

    QSerialPort serialPort;

    QStringList m_TableHeader;

    bool m_bUpdateInputs;

    void TxSlipFrame(void);
    unsigned char UnWrapSlipFrame(unsigned char *BuffIn, unsigned char *BuffOut);
    void WatchDog (void);

    void UpdateInputs();
    void UpdateOutputs();
};

class Sleeper : public QThread
{
public:
    static void usleep(unsigned long usecs){QThread::usleep(usecs);}
    static void msleep(unsigned long msecs){QThread::msleep(msecs);}
    static void sleep(unsigned long secs){QThread::sleep(secs);}
};

#endif // MAINWINDOW_H
